
<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.loan',1)); ?>  <?php echo e(trans_choice('general.detail',2)); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-md-12">
            <!-- Custom Tabs -->
            <div class="panel panel-white">
                <div class="panel-body">
                    <ul class="nav nav-tabs">
                        <?php if($loan->status=="disbursed" || $loan->status=="closed" || $loan->status=="withdrawn" || $loan->status=="written_off" || $loan->status=="rescheduled" ): ?>
                            <li class=""><a href="#transactions" data-toggle="tab"
                                            aria-expanded="true"><?php echo e(trans_choice('general.transaction',2)); ?></a></li>
                            <li><a href="#loan_schedule" data-toggle="tab"
                                   aria-expanded="false"><?php echo e(trans_choice('general.loan',1)); ?>

                                    <?php echo e(trans_choice('general.schedule',1)); ?></a></li>
                            <li class=""><a href="#pending_dues" data-toggle="tab"
                                            aria-expanded="false"><?php echo e(trans_choice('general.summary',1)); ?></a>
                            </li>

                        <?php endif; ?>
                        <li class="active"><a href="#loan_terms" data-toggle="tab"
                                              aria-expanded="false"> <?php echo e(trans_choice('general.detail',2)); ?></a>
                        </li>

                        <li class=""><a href="#loan_collateral" data-toggle="tab"
                                        aria-expanded="false"><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.collateral',1)); ?></a>
                        </li>
                        <li class=""><a href="#loan_guarantors" data-toggle="tab"
                                        aria-expanded="false"><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.guarantor',2)); ?></a>
                        </li>
                        <li class=""><a href="#loan_files" data-toggle="tab"
                                        aria-expanded="false"><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.file',2)); ?></a>
                        </li>


                    </ul>
                    <div class="tab-content">
                    <?php if($loan->status=="disbursed" || $loan->status=="closed" || $loan->status=="withdrawn" || $loan->status=="written_off" || $loan->status=="rescheduled" ): ?>
                        <!-- /.tab-pane -->
                            <div class="tab-pane " id="transactions">
                                <div class="btn-group-horizontal">
                                    <?php if(\App\Models\Setting::where('setting_key','enable_online_payment')->first()->setting_value==1): ?>
                                        <a type="button" class="btn btn-info m-10"
                                           href="<?php echo e(url('client/loan/'.$loan->id.'/pay')); ?>"><?php echo e(trans_choice('general.add',1)); ?>

                                            <?php echo e(trans_choice('general.repayment',1)); ?></a>
                                    <?php endif; ?>
                                </div>
                                <div class="box box-info">
                                    <div class="panel-body">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="table-responsive">
                                                    <table id="repayments-data-table"
                                                           class="table  table-condensed table-hover">
                                                        <thead>
                                                        <tr>
                                                            <th>
                                                                <?php echo e(trans_choice('general.id',1)); ?>

                                                            </th>
                                                            <th>
                                                                <?php echo e(trans_choice('general.date',1)); ?>

                                                            </th>
                                                            <th>
                                                                <?php echo e(trans_choice('general.submitted',1)); ?> <?php echo e(trans_choice('general.on',1)); ?>

                                                            </th>
                                                            <th>
                                                                <?php echo e(trans_choice('general.type',1)); ?>

                                                            </th>

                                                            <th>
                                                                <?php echo e(trans_choice('general.debit',1)); ?>

                                                            </th>
                                                            <th>
                                                                <?php echo e(trans_choice('general.credit',1)); ?>

                                                            </th>
                                                            <th>
                                                                <?php echo e(trans_choice('general.balance',1)); ?>

                                                            </th>
                                                            <th>
                                                                <?php echo e(trans_choice('general.detail',2)); ?>

                                                            </th>

                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        <?php
                                                        $balance = 0;
                                                        ?>
                                                        <?php $__currentLoopData = \App\Models\LoanTransaction::where('loan_id',$loan->id)->whereIn('reversal_type',['user','none'])->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php
                                                            $balance = $balance + ($key->debit - $key->credit);
                                                            ?>
                                                            <tr>
                                                                <td><?php echo e($key->id); ?></td>
                                                                <td><?php echo e($key->date); ?></td>
                                                                <td><?php echo e($key->created_at); ?></td>
                                                                <td>
                                                                    <?php if($key->transaction_type=='disbursement'): ?>
                                                                        <?php echo e(trans_choice('general.disbursement',1)); ?>

                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='specified_due_date_fee'): ?>
                                                                        <?php echo e(trans_choice('general.specified_due_date',2)); ?>   <?php echo e(trans_choice('general.fee',1)); ?>

                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='installment_fee'): ?>
                                                                        <?php echo e(trans_choice('general.installment_fee',2)); ?>

                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='overdue_installment_fee'): ?>
                                                                        <?php echo e(trans_choice('general.overdue_installment_fee',2)); ?>

                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='loan_rescheduling_fee'): ?>
                                                                        <?php echo e(trans_choice('general.loan_rescheduling_fee',2)); ?>

                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='overdue_maturity'): ?>
                                                                        <?php echo e(trans_choice('general.overdue_maturity',2)); ?>

                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='disbursement_fee'): ?>
                                                                        <?php echo e(trans_choice('general.disbursement',1)); ?> <?php echo e(trans_choice('general.charge',2)); ?>

                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='interest'): ?>
                                                                        <?php echo e(trans_choice('general.interest',1)); ?> <?php echo e(trans_choice('general.applied',2)); ?>

                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='repayment'): ?>
                                                                        <?php echo e(trans_choice('general.repayment',1)); ?>

                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='penalty'): ?>
                                                                        <?php echo e(trans_choice('general.penalty',1)); ?>

                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='interest_waiver'): ?>
                                                                        <?php echo e(trans_choice('general.interest',1)); ?> <?php echo e(trans_choice('general.waiver',2)); ?>

                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='waiver'): ?>
                                                                        <?php echo e(trans_choice('general.waiver',2)); ?>

                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='charge_waiver'): ?>
                                                                        <?php echo e(trans_choice('general.charge',1)); ?>  <?php echo e(trans_choice('general.waiver',2)); ?>

                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='write_off'): ?>
                                                                        <?php echo e(trans_choice('general.write_off',1)); ?>

                                                                    <?php endif; ?>
                                                                    <?php if($key->transaction_type=='write_off_recovery'): ?>
                                                                        <?php echo e(trans_choice('general.recovery',1)); ?> <?php echo e(trans_choice('general.repayment',1)); ?>

                                                                    <?php endif; ?>
                                                                    <?php if($key->reversed==1): ?>
                                                                        <?php if($key->reversal_type=="user"): ?>
                                                                            <span class="text-danger"><b>(<?php echo e(trans_choice('general.user',1)); ?> <?php echo e(trans_choice('general.reversed',1)); ?>

                                                                                    )</b></span>
                                                                        <?php endif; ?>
                                                                        <?php if($key->reversal_type=="system"): ?>
                                                                            <span class="text-danger"><b>(<?php echo e(trans_choice('general.system',1)); ?> <?php echo e(trans_choice('general.reversed',1)); ?>

                                                                                    )</b></span>
                                                                        <?php endif; ?>
                                                                    <?php endif; ?>
                                                                </td>
                                                                <td><?php echo e(number_format($key->debit,2)); ?></td>
                                                                <td><?php echo e(number_format($key->credit,2)); ?></td>
                                                                <td><?php echo e(number_format($balance,2)); ?></td>
                                                                <td><?php echo e($key->receipt); ?></td>

                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /.tab-pane -->
                            <!-- /.tab-pane -->
                            <div class="tab-pane" id="loan_schedule">
                                <div class="row">
                                    <div class="col-sm-3">

                                        <div class="input-group-btn">
                                            <button type="button" class="btn btn-info dropdown-toggle m-10"
                                                    data-toggle="dropdown"
                                                    aria-expanded="false"><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.schedule',1)); ?>

                                                <span class="fa fa-caret-down"></span></button>
                                            <ul class="dropdown-menu" role="menu">
                                                <li>
                                                    <a href="<?php echo e(url('client/loan/'.$loan->id.'/schedule/print')); ?>"
                                                       target="_blank"><?php echo e(trans_choice('general.print',1)); ?> <?php echo e(trans_choice('general.statement',1)); ?></a>
                                                </li>
                                                <li>
                                                    <a href="<?php echo e(url('client/loan/'.$loan->id.'/schedule/pdf')); ?>"
                                                       target="_blank"><?php echo e(trans_choice('general.download',1)); ?> <?php echo e(trans_choice('general.in',1)); ?> <?php echo e(trans_choice('general.pdf',1)); ?></a>
                                                </li>


                                            </ul>
                                        </div>
                                    </div>
                                    <div class="col-sm-9 pull-right">
                                        <div class="btn-group-horizontal">
                                            <a type="button" class="btn btn-info m-10"
                                               href="<?php echo e(url('client/loan/'.$loan->id.'/schedule/print')); ?>"
                                               target="_blank"><?php echo e(trans_choice('general.print',1)); ?> <?php echo e(trans_choice('general.schedule',1)); ?></a>

                                        </div>
                                    </div>
                                </div>
                                <div class="box box-success">
                                    <div class="panel-body table-responsive no-padding">
                                        <table class="table table-bordered table-condensed table-hover">
                                            <tbody>
                                            <tr>
                                                <th style="width: 10px">
                                                    <b>#</b>
                                                </th>
                                                <th>
                                                    <b><?php echo e(trans_choice('general.date',1)); ?></b>
                                                </th>
                                                <th style="text-align:right;">
                                                    <b><?php echo e(trans_choice('general.paid',1)); ?> <?php echo e(trans_choice('general.by',1)); ?></b>
                                                </th>
                                                <th>
                                                    <b><?php echo e(trans_choice('general.description',1)); ?></b>
                                                </th>
                                                <th style="">
                                                    <b><?php echo e(trans_choice('general.principal',1)); ?></b>
                                                </th>
                                                <th style="text-align:right;">
                                                    <b><?php echo e(trans_choice('general.interest',1)); ?></b>
                                                </th>
                                                <th style="text-align:right;">
                                                    <b><?php echo e(trans_choice('general.fee',2)); ?></b>
                                                </th>
                                                <th style="text-align:right;">
                                                    <b><?php echo e(trans_choice('general.penalty',1)); ?></b>
                                                </th>

                                                <th style="text-align:right;">
                                                    <b> <?php echo e(trans_choice('general.due',1)); ?></b>
                                                </th>
                                                <th style="text-align:right;">
                                                    <b><?php echo e(trans_choice('general.paid',1)); ?></b>
                                                </th>
                                                <th style="text-align:right;">
                                                    <b> <?php echo e(trans_choice('general.pending',1)); ?> <?php echo e(trans_choice('general.due',1)); ?></b>
                                                </th>
                                                <th style="text-align:right;">
                                                    <b> <?php echo e(trans_choice('general.principal',1)); ?> <?php echo e(trans_choice('general.balance',1)); ?></b>
                                                </th>
                                            </tr>
                                            <?php
                                            //check for disbursement charges
                                            $disbursement_charges = \App\Models\LoanTransaction::where('loan_id',
                                                $loan->id)->where('transaction_type',
                                                'disbursement_fee')->where('reversed', 0)->sum('debit');
                                            ?>
                                            <tr>
                                                <td></td>
                                                <td><?php echo e($loan->release_date); ?></td>
                                                <td></td>
                                                <td><?php echo e(trans_choice('general.disbursement',1)); ?></td>
                                                <td></td>
                                                <td></td>
                                                <td style="text-align:right;">
                                                    <?php if(!empty($disbursement_charges)): ?>
                                                        <b><?php echo e(number_format($disbursement_charges,2)); ?></b>
                                                    <?php endif; ?>
                                                </td>
                                                <td></td>
                                                <td style="text-align:right;">
                                                    <?php if(!empty($disbursement_charges)): ?>
                                                        <b><?php echo e(number_format($disbursement_charges,2)); ?></b>
                                                    <?php endif; ?>
                                                </td>
                                                <td style="text-align:right;">
                                                    <?php if(!empty($disbursement_charges)): ?>
                                                        <b><?php echo e(number_format($disbursement_charges,2)); ?></b>
                                                    <?php endif; ?>
                                                </td>
                                                <td></td>
                                                <td style="text-align:right;">
                                                    <?php echo e(number_format(\App\Models\LoanSchedule::where('loan_id',
                                                    $loan->id)->sum('principal'),2)); ?>

                                                </td>
                                            </tr>
                                            <?php
                                            $timely = 0;
                                            $total_overdue = 0;
                                            $overdue_date = "";
                                            $total_till_now = 0;
                                            $count = 1;
                                            $total_due = 0;
                                            $principal_balance = \App\Models\LoanSchedule::where('loan_id',
                                                $loan->id)->sum('principal');
                                            $payments = \App\Helpers\GeneralHelper::loan_total_paid($loan->id);
                                            $total_paid = $payments;
                                            $next_payment = [];
                                            $next_payment_amount = "";
                                            foreach ($loan->schedules as $schedule) {
                                            $principal_balance = $principal_balance - $schedule->principal;
                                            $total_due = $total_due + ($schedule->principal + $schedule->interest + $schedule->fees + $schedule->penalty- $schedule->interest_waived);
                                            $paid = 0;
                                            $paid_by = '';
                                            $overdue = 0;
                                            $due = $schedule->principal + $schedule->interest + $schedule->fees + $schedule->penalty- $schedule->interest_waived;
                                            if ($payments > 0) {
                                                if ($payments > $due) {
                                                    $paid = $due;
                                                    $payments = $payments - $due;
                                                    //find the corresponding paid by date
                                                    $p_paid = 0;
                                                    foreach (\App\Models\LoanTransaction::where('loan_id',
                                                        $loan->id)->where('transaction_type',
                                                        'repayment')->where('reversed', 0)->orderBy('date',
                                                        'asc')->get() as $key) {
                                                        $p_paid = $p_paid + $key->credit;
                                                        if ($p_paid >= $total_due) {
                                                            $paid_by = $key->date;
                                                            if ($key->date > $schedule->due_date && date("Y-m-d") > $schedule->due_date) {
                                                                $overdue = 1;
                                                                $total_overdue = $total_overdue + 1;
                                                                $overdue_date = '';
                                                            }
                                                            break;
                                                        }
                                                    }
                                                } else {
                                                    $paid = $payments;
                                                    $payments = 0;
                                                    if (date("Y-m-d") > $schedule->due_date) {
                                                        $overdue = 1;
                                                        $total_overdue = $total_overdue + 1;
                                                        $overdue_date = $schedule->due_date;
                                                    }
                                                    $next_payment[$schedule->due_date] = (($schedule->principal + $schedule->interest + $schedule->fees + $schedule->penalty- $schedule->interest_waived) - $paid);
                                                }
                                            } else {
                                                if (date("Y-m-d") > $schedule->due_date) {
                                                    $overdue = 1;
                                                    $total_overdue = $total_overdue + 1;
                                                    $overdue_date = $schedule->due_date;
                                                }
                                                $next_payment[$schedule->due_date] = (($schedule->principal + $schedule->interest + $schedule->fees + $schedule->penalty- $schedule->interest_waived));
                                            }
                                            $outstanding = $due - $paid;
                                            //check if the schedule has been paid in time


                                            ?>
                                            <tr class="<?php if($overdue==1): ?> danger  <?php endif; ?> <?php if($overdue==0 && $outstanding==0): ?> success  <?php endif; ?>">
                                                <td>
                                                    <?php echo e($count); ?>

                                                </td>
                                                <td>
                                                    <?php echo e($schedule->due_date); ?>

                                                </td>
                                                <td style="">
                                                    <?php if(empty($paid_by) && $overdue==1): ?>
                                                        <?php echo e(trans_choice('general.overdue',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if(!empty($paid_by) && $overdue==1): ?>
                                                        <?php echo e($paid_by); ?> <i class="fa fa-minus-circle" data-toggle="tooltip"
                                                                        title=" <?php echo e(trans_choice('general.late',1)); ?>"></i>
                                                    <?php endif; ?>
                                                    <?php if(!empty($paid_by) && $overdue==0): ?>
                                                        <?php echo e($paid_by); ?> <i class="fa fa-check-circle" data-toggle="tooltip"
                                                                        title=" <?php echo e(trans_choice('general.timely',1)); ?>"></i>
                                                    <?php endif; ?>

                                                </td>
                                                <td>
                                                    <?php echo e($schedule->description); ?>

                                                </td>
                                                <td style="text-align:right">
                                                    <?php echo e(number_format($schedule->principal,2)); ?>

                                                </td>
                                                <td style="text-align:right">
                                                    <?php if($schedule->interest_waived>0): ?>
                                                        <s> <?php echo e(number_format($schedule->interest_waived,2)); ?></s>
                                                    <?php endif; ?>
                                                    <?php echo e(number_format($schedule->interest,2)); ?>

                                                </td>
                                                <td style="text-align:right">
                                                    <?php echo e(number_format($schedule->fees,2)); ?>

                                                </td>
                                                <td style="text-align:right">
                                                    <?php echo e(number_format($schedule->penalty,2)); ?>

                                                </td>
                                                <td style="text-align:right; font-weight:bold">
                                                    <?php echo e(number_format($due,2)); ?>

                                                </td>

                                                <td style="text-align:right;">
                                                    <?php echo e(number_format($paid,2)); ?>

                                                </td>
                                                <td style="text-align:right;">
                                                    <?php echo e(number_format($outstanding,2)); ?>

                                                </td>
                                                <td style="text-align:right;">
                                                    <?php echo e(number_format($principal_balance,2)); ?>

                                                </td>

                                            </tr>
                                            <?php
                                            $count++;
                                            }
                                            ?>
                                            <tr>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td style="font-weight:bold"><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.due',1)); ?></td>
                                                <td style="text-align:right;">
                                                    <?php echo e(number_format(\App\Helpers\GeneralHelper::loan_total_principal($loan->id),2)); ?>

                                                </td>
                                                <td style="text-align:right;">
                                                    <?php echo e(number_format(\App\Helpers\GeneralHelper::loan_total_interest($loan->id)-\App\Helpers\GeneralHelper::loan_total_interest_waived($loan->id),2)); ?>

                                                </td>
                                                <td style="text-align:right;">
                                                    <?php echo e(number_format(\App\Helpers\GeneralHelper::loan_total_fees($loan->id)+$disbursement_charges,2)); ?>

                                                </td>
                                                <td style="text-align:right;">
                                                    <?php echo e(number_format(\App\Helpers\GeneralHelper::loan_total_penalty($loan->id),2)); ?>

                                                </td>
                                                <td style="text-align:right;">
                                                    <?php echo e(number_format($total_due+$disbursement_charges,2)); ?>

                                                </td>
                                                <td style="text-align:right;">
                                                    <?php echo e(number_format($total_paid+$disbursement_charges,2)); ?>

                                                </td>
                                                <td style="text-align:right;">
                                                    <?php echo e(number_format(\App\Helpers\GeneralHelper::loan_total_balance($loan->id),2)); ?>

                                                </td>
                                                <td></td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="pending_dues">
                                <div class="tab_content">
                                    <?php
                                    $loan_due_items = \App\Helpers\GeneralHelper::loan_due_items($loan->id,
                                        $loan->release_date, date("Y-m-d"));
                                    $loan_paid_items = \App\Helpers\GeneralHelper::loan_paid_items($loan->id,
                                        $loan->release_date, date("Y-m-d"));

                                    ?>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="row">
                                                <div class="col-md-6"><h6>
                                                        <b><?php echo e(trans_choice('general.timely',1)); ?> <?php echo e(trans_choice('general.repayment',2)); ?>

                                                            :</b></h6></div>
                                                <div class="col-md-6">
                                                    <?php
                                                    $count = \App\Models\LoanSchedule::where('due_date', '<=',
                                                        date("Y-m-d"))->where('loan_id', $loan->id)->count();
                                                    ?>
                                                    <?php if($count>0): ?>
                                                        <h6><b><?php echo e(round(($count-$total_overdue)/$count)); ?>%</b></h6>
                                                    <?php else: ?>
                                                        <h6><b>0 %</b></h6>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6"><h6>
                                                        <b><?php echo e(trans_choice('general.amount',1)); ?> <?php echo e(trans_choice('general.in',1)); ?> <?php echo e(trans_choice('general.arrears',2)); ?>

                                                            :</b></h6></div>
                                                <div class="col-md-6">
                                                    <?php if(($loan_due_items["principal"]+$loan_due_items["interest"]+$loan_due_items["fees"]+$loan_due_items["penalty"])>($loan_paid_items["principal"]+$loan_paid_items["interest"]+$loan_paid_items["fees"]+$loan_paid_items["penalty"])): ?>
                                                        <h6><b>
                                                                <span class="text-danger"><?php echo e(number_format(($loan_due_items["principal"]+$loan_due_items["interest"]+$loan_due_items["fees"]+$loan_due_items["penalty"])-($loan_paid_items["principal"]+$loan_paid_items["interest"]+$loan_paid_items["fees"]+$loan_paid_items["penalty"]),2)); ?></span></b>
                                                        </h6>
                                                    <?php else: ?>
                                                        <h6><b> <span class="text-danger">0.00</span></b></h6>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6"><h6>
                                                        <b><?php echo e(trans_choice('general.day',2)); ?> <?php echo e(trans_choice('general.in',1)); ?> <?php echo e(trans_choice('general.arrears',2)); ?>

                                                            :</b></h6></div>
                                                <div class="col-md-6">
                                                    <?php if(!empty($overdue_date)): ?>
                                                        <?php
                                                        $date1 = new DateTime($overdue_date);
                                                        $date2 = new DateTime(date("Y-m-d"));
                                                        ?>
                                                        <h6>
                                                            <b><span class="text-danger"><?php echo e($date2->diff($date1)->format("%a")); ?></span></b>
                                                        </h6>
                                                    <?php else: ?>
                                                        <h6><b> <span class="text-danger">0</span></b></h6>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="row">
                                                <div class="col-md-6"><h6>
                                                        <b><?php echo e(trans_choice('general.last',1)); ?> <?php echo e(trans_choice('general.payment',1)); ?>

                                                            :</b></h6></div>
                                                <div class="col-md-6">
                                                    <?php
                                                    $last_payment = \App\Models\LoanTransaction::where('loan_id',
                                                        $loan->id)->where('transaction_type',
                                                        'repayment')->where('reversed', 0)->orderBy('date',
                                                        'desc')->first();
                                                    ?>
                                                    <?php if(!empty($last_payment)): ?>
                                                        <h6><b><?php echo e(number_format($last_payment->credit)); ?>

                                                                on <?php echo e($last_payment->date); ?></b></h6>
                                                    <?php else: ?>
                                                        ----
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6"><h6>
                                                        <b><?php echo e(trans_choice('general.next',1)); ?> <?php echo e(trans_choice('general.payment',1)); ?>

                                                            :</b></h6></div>
                                                <div class="col-md-6">
                                                    <?php
                                                    $count = \App\Models\LoanSchedule::where('due_date', '<=',
                                                        date("Y-m-d"))->where('loan_id', $loan->id)->count();
                                                    ?>
                                                    <?php $__currentLoopData = $next_payment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                        if ($key > date("Y-m-d")) {
                                                            echo ' <h6><b>' . number_format($value) . ' on ' . $key . '</b></h6>';
                                                            break;
                                                        }
                                                        ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6"><h6>
                                                        <b><?php echo e(trans_choice('general.last',1)); ?> <?php echo e(trans_choice('general.payment',1)); ?> <?php echo e(trans_choice('general.expected',2)); ?>

                                                            :</b></h6></div>
                                                <div class="col-md-6">
                                                    <h6>
                                                        <b><?php echo e(\App\Models\LoanSchedule::where('loan_id', $loan->id)->orderBy('due_date','asc')->get()->last()->due_date); ?></b>
                                                    </h6>
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                    <table class="table table-bordered table-condensed">
                                        <tbody>
                                        <tr class="bg-success">
                                            <th width="200">
                                                <b><?php echo e(trans_choice('general.item',1)); ?>

                                                    :</b>
                                            </th>
                                            <th style="text-align:right;">
                                                <b><?php echo e(trans_choice('general.principal',1)); ?></b>
                                            </th>
                                            <th style="text-align:right;">
                                                <b><?php echo e(trans_choice('general.interest',1)); ?></b>
                                            </th>
                                            <th style="text-align:right;">
                                                <b><?php echo e(trans_choice('general.fee',2)); ?></b>
                                            </th>
                                            <th style="text-align:right;">
                                                <b><?php echo e(trans_choice('general.penalty',1)); ?></b>
                                            </th>
                                            <th style="text-align:right;">
                                                <b><?php echo e(trans_choice('general.total',1)); ?></b>
                                            </th>
                                        </tr>
                                        <tr>
                                            <td class="text-bold bg-danger">
                                                <?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.due',1)); ?>

                                            </td>
                                            <td style="text-align:right">
                                                <?php echo e(number_format(\App\Helpers\GeneralHelper::loan_total_principal($loan->id),2)); ?>

                                            </td>
                                            <td style="text-align:right">
                                                <?php echo e(number_format(\App\Helpers\GeneralHelper::loan_total_interest($loan->id),2)); ?>

                                            </td>
                                            <td style="text-align:right">
                                                <?php echo e(number_format(\App\Helpers\GeneralHelper::loan_total_fees($loan->id)+$disbursement_charges,2)); ?>

                                            </td>
                                            <td style="text-align:right">
                                                <?php echo e(number_format(\App\Helpers\GeneralHelper::loan_total_penalty($loan->id),2)); ?>

                                            </td>
                                            <td style="text-align:right; font-weight:bold">
                                                <?php echo e(number_format(\App\Helpers\GeneralHelper::loan_total_due_amount($loan->id)+$disbursement_charges,2)); ?>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="text-bold bg-green">
                                                <?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.paid',1)); ?>

                                            </td>
                                            <td style="text-align:right">
                                                <?php echo e(number_format($loan_paid_items['principal'],2)); ?>

                                            </td>
                                            <td style="text-align:right">
                                                <?php echo e(number_format($loan_paid_items['interest'],2)); ?>

                                            </td>
                                            <td style="text-align:right">
                                                <?php echo e(number_format($loan_paid_items['fees']+$disbursement_charges,2)); ?>

                                            </td>
                                            <td style="text-align:right">
                                                <?php echo e(number_format($loan_paid_items['penalty'],2)); ?>

                                            </td>
                                            <td style="text-align:right; font-weight:bold">
                                                <?php echo e(number_format(($loan_paid_items['principal']+$loan_paid_items['interest']+$loan_paid_items['fees']+$loan_paid_items['penalty'])+$disbursement_charges,2)); ?>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="text-bold btn-info">
                                                <?php echo e(trans_choice('general.balance',1)); ?>

                                            </td>
                                            <td style="text-align:right">
                                                <?php echo e(number_format((\App\Helpers\GeneralHelper::loan_total_principal($loan->id)-$loan_paid_items['principal']),2)); ?>

                                            </td>
                                            <td style="text-align:right">
                                                <?php echo e(number_format((\App\Helpers\GeneralHelper::loan_total_interest($loan->id)-$loan_paid_items['interest']),2)); ?>


                                            </td>
                                            <td style="text-align:right">
                                                <?php echo e(number_format((\App\Helpers\GeneralHelper::loan_total_fees($loan->id)-$loan_paid_items['fees']),2)); ?>


                                            </td>
                                            <td style="text-align:right">
                                                <?php echo e(number_format((\App\Helpers\GeneralHelper::loan_total_penalty($loan->id)-$loan_paid_items['penalty']),2)); ?>


                                            </td>
                                            <td style="text-align:right; font-weight:bold">
                                                <?php echo e(number_format((\App\Helpers\GeneralHelper::loan_total_due_amount($loan->id)-($loan_paid_items['principal']+$loan_paid_items['interest']+$loan_paid_items['fees']+$loan_paid_items['penalty'])),2)); ?>


                                            </td>
                                        </tr>

                                        </tbody>
                                    </table>
                                </div>
                            </div>


                        <?php endif; ?>
                        <div class="tab-pane active" id="loan_terms">
                            <div class="row">
                                <div class="col-sm-8">

                                    <?php if($loan->status=='declined'): ?>

                                    <?php endif; ?>
                                    <?php if($loan->status=='approved'): ?>

                                    <?php endif; ?>
                                    <?php if($loan->status=='written_off'): ?>

                                    <?php endif; ?>
                                    <?php if($loan->status=='withdrawn'): ?>
                                        <div class="col-sm-6">

                                        </div>
                                    <?php endif; ?>
                                    <?php if($loan->status=='disbursed'): ?>

                                    <?php endif; ?>

                                    <?php if($loan->status=="disbursed" || $loan->status=="closed" || $loan->status=="withdrawn" || $loan->status=="written_off" || $loan->status=="rescheduled" ): ?>
                                        <div class="col-sm-3">
                                            <div class="input-group-btn">
                                                <button type="button" class="btn btn-info dropdown-toggle m-10"
                                                        data-toggle="dropdown"
                                                        aria-expanded="false"><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.schedule',1)); ?>

                                                    <span class="fa fa-caret-down"></span></button>
                                                <ul class="dropdown-menu" role="menu">

                                                    <li>
                                                        <a href="<?php echo e(url('client/loan/'.$loan->id.'/loan_statement/print')); ?>"
                                                           target="_blank"><?php echo e(trans_choice('general.print',1)); ?> <?php echo e(trans_choice('general.statement',1)); ?></a>
                                                    </li>

                                                    <li>
                                                        <a href="<?php echo e(url('client/loan/'.$loan->id.'/loan_statement/pdf')); ?>"
                                                           target="_blank"><?php echo e(trans_choice('general.download',1)); ?> <?php echo e(trans_choice('general.in',1)); ?> <?php echo e(trans_choice('general.pdf',1)); ?></a>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <div class="col-sm-4 pull-right">
                                    <div class="btn-group-horizontal">

                                    </div>
                                </div>
                            </div>

                            <div class="panel-body no-padding">
                                <table class="table table-condensed">
                                    <tbody>
                                    <tr>
                                        <td>
                                            <b><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.status',1)); ?></b>
                                        </td>
                                        <td>
                                            <?php if($loan->maturity_date<date("Y-m-d") && \App\Helpers\GeneralHelper::loan_total_balance($loan->id)>0): ?>
                                                <span class="label label-danger"><?php echo e(trans_choice('general.past_maturity',1)); ?></span>
                                            <?php else: ?>
                                                <?php if($loan->status=='pending'): ?>
                                                    <span class="label label-warning"><?php echo e(trans_choice('general.pending',1)); ?> <?php echo e(trans_choice('general.approval',1)); ?></span>
                                                <?php endif; ?>
                                                <?php if($loan->status=='approved'): ?>
                                                    <span class="label label-info"><?php echo e(trans_choice('general.awaiting',1)); ?> <?php echo e(trans_choice('general.disbursement',1)); ?></span>
                                                <?php endif; ?>
                                                <?php if($loan->status=='disbursed'): ?>
                                                    <span class="label label-info"><?php echo e(trans_choice('general.active',1)); ?></span>
                                                <?php endif; ?>
                                                <?php if($loan->status=='declined'): ?>
                                                    <span class="label label-danger"><?php echo e(trans_choice('general.declined',1)); ?></span>
                                                <?php endif; ?>
                                                <?php if($loan->status=='withdrawn'): ?>
                                                    <span class="label label-danger"><?php echo e(trans_choice('general.withdrawn',1)); ?></span>
                                                <?php endif; ?>
                                                <?php if($loan->status=='written_off'): ?>
                                                    <span class="label label-danger"><?php echo e(trans_choice('general.written_off',1)); ?></span>
                                                <?php endif; ?>
                                                <?php if($loan->status=='closed'): ?>
                                                    <span class="label label-success"><?php echo e(trans_choice('general.closed',1)); ?></span>
                                                <?php endif; ?>
                                                <?php if($loan->status=='pending_reschedule'): ?>
                                                    <span class="label label-warning"><?php echo e(trans_choice('general.pending',1)); ?> <?php echo e(trans_choice('general.reschedule',1)); ?></span>
                                                <?php endif; ?>
                                                <?php if($loan->status=='rescheduled'): ?>
                                                    <span class="label label-info"><?php echo e(trans_choice('general.rescheduled',1)); ?></span>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>

                                        <td width="200">
                                            <b><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.application',1)); ?> <?php echo e(trans_choice('general.id',1)); ?></b>
                                        </td>
                                        <td><?php echo e($loan->id); ?></td>

                                    </tr>
                                    <tr>
                                        <td>
                                            <b><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.product',1)); ?></b>
                                        </td>
                                        <td>
                                            <?php if(!empty($loan->loan_product)): ?>
                                                <?php echo e($loan->loan_product->name); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" class="bg-navy disabled color-palette">
                                            <?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.term',2)); ?>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td><b><?php echo e(trans_choice('general.disbursed_by',1)); ?></b></td>
                                        <td>
                                            <?php if(!empty($loan->loan_disbursed_by)): ?>
                                                <?php echo e($loan->loan_disbursed_by->name); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>

                                        <td>
                                            <b><?php echo e(trans_choice('general.principal',1)); ?> <?php echo e(trans_choice('general.amount',1)); ?></b>
                                        </td>
                                        <td><?php echo e(number_format($loan->principal,2)); ?></td>

                                    </tr>
                                    <tr>

                                        <td>
                                            <b><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.release',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></b>
                                        </td>
                                        <td><?php echo e($loan->release_date); ?></td>

                                    </tr>
                                    <tr>
                                        <td>
                                            <b><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.interest',1)); ?> <?php echo e(trans_choice('general.method',1)); ?></b>
                                        </td>
                                        <td>
                                            <?php if($loan->interest_method=='declining_balance_equal_installments'): ?>
                                                <?php echo e(trans_choice('general.declining_balance_equal_installments',1)); ?>

                                            <?php endif; ?>
                                            <?php if($loan->interest_method=='declining_balance_equal_principal'): ?>
                                                <?php echo e(trans_choice('general.declining_balance_equal_principal',1)); ?>

                                            <?php endif; ?>
                                            <?php if($loan->interest_method=='interest_only'): ?>
                                                <?php echo e(trans_choice('general.interest_only',1)); ?>

                                            <?php endif; ?>
                                            <?php if($loan->interest_method=='flat_rate'): ?>
                                                <?php echo e(trans_choice('general.flat_rate',1)); ?>

                                            <?php endif; ?>
                                            <?php if($loan->interest_method=='compound_interest'): ?>
                                                <?php echo e(trans_choice('general.compound_interest',1)); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <b><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.interest',1)); ?></b>
                                        </td>
                                        <td><?php echo e(number_format($loan->interest_rate,2)); ?>%/<?php echo e($loan->interest_period); ?>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <b><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.duration',1)); ?></b>
                                        </td>
                                        <td><?php echo e($loan->loan_duration); ?> <?php echo e($loan->loan_duration_type); ?>s
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><b><?php echo e(trans_choice('general.repayment_cycle',1)); ?></b></td>
                                        <td>
                                            <?php if($loan->repayment_cycle=='daily'): ?>
                                                <?php echo e(trans_choice('general.daily',1)); ?>

                                            <?php endif; ?>
                                            <?php if($loan->repayment_cycle=='weekly'): ?>
                                                <?php echo e(trans_choice('general.weekly',1)); ?>

                                            <?php endif; ?>
                                            <?php if($loan->repayment_cycle=='monthly'): ?>
                                                <?php echo e(trans_choice('general.monthly',1)); ?>

                                            <?php endif; ?>
                                            <?php if($loan->repayment_cycle=='bi_monthly'): ?>
                                                <?php echo e(trans_choice('general.bi_monthly',1)); ?>

                                            <?php endif; ?>
                                            <?php if($loan->repayment_cycle=='quarterly'): ?>
                                                <?php echo e(trans_choice('general.quarterly',1)); ?>

                                            <?php endif; ?>
                                            <?php if($loan->repayment_cycle=='semi_annual'): ?>
                                                <?php echo e(trans_choice('general.semi_annually',1)); ?>

                                            <?php endif; ?>
                                            <?php if($loan->repayment_cycle=='annually'): ?>
                                                <?php echo e(trans_choice('general.annual',1)); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td><b><?php echo e(trans_choice('general.number',1)); ?>

                                                of <?php echo e(trans_choice('general.repayment',2)); ?></b></td>
                                        <td>
                                            <?php echo e(\App\Models\LoanSchedule::where('loan_id',$loan->id)->count()); ?>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td><b><?php echo e(trans_choice('general.decimal_place',1)); ?></b></td>
                                        <td>
                                            <?php if($loan->decimal_places=='round_off_to_two_decimal'): ?>
                                                <?php echo e(trans_choice('general.round_off_to_two_decimal',1)); ?>

                                            <?php endif; ?>
                                            <?php if($loan->decimal_places=='round_off_to_integer'): ?>
                                                <?php echo e(trans_choice('general.round_off_to_integer',1)); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <b><?php echo e(trans_choice('general.first',1)); ?> <?php echo e(trans_choice('general.repayment',1)); ?> <?php echo e(trans_choice('general.date',1)); ?></b>
                                        </td>
                                        <td><?php echo e($loan->first_payment_date); ?></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2"></td>
                                    </tr>

                                    </tbody>
                                </table>
                            </div>

                        </div>
                        <div class="tab-pane" id="loan_collateral">
                            <div class="btn-group-horizontal">

                            </div>
                            <div class="box box-success">
                                <div class="table-responsive">
                                    <table id="data-table" class="table table-striped table-condensed table-hover">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(trans_choice('general.type',1)); ?></th>
                                            <th><?php echo e(trans_choice('general.name',1)); ?></th>
                                            <th><?php echo e(trans_choice('general.value',1)); ?></th>
                                            <th><?php echo e(trans_choice('general.status',1)); ?></th>
                                            <th><?php echo e(trans_choice('general.date',1)); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $loan->collateral; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td>
                                                    <?php if(!empty($key->collateral_type)): ?>
                                                        <?php echo e($key->collateral_type->name); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($key->name); ?></td>
                                                <td><?php echo e($key->value); ?></td>
                                                <td>
                                                    <?php if($key->status=='deposited_into_branch'): ?>
                                                        <?php echo e(trans_choice('general.deposited_into_branch',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($key->status=='collateral_with_borrower'): ?>
                                                        <?php echo e(trans_choice('general.collateral_with_borrower',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($key->status=='returned_to_borrower'): ?>
                                                        <?php echo e(trans_choice('general.returned_to_borrower',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($key->status=='repossession_initiated'): ?>
                                                        <?php echo e(trans_choice('general.repossession_initiated',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($key->status=='repossessed'): ?>
                                                        <?php echo e(trans_choice('general.repossessed',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($key->status=='sold'): ?>
                                                        <?php echo e(trans_choice('general.sold',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($key->status=='lost'): ?>
                                                        <?php echo e(trans_choice('general.lost',1)); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($key->date); ?></td>

                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane" id="loan_guarantors">
                            <div class="btn-group-horizontal">

                            </div>
                            <div class="box box-success">
                                <div class="table-responsive">
                                    <table id="data-table" class="table table-bordered table-condensed table-hover">
                                        <thead>
                                        <tr>
                                            <th><?php echo e(trans_choice('general.full_name',1)); ?></th>
                                            <th><?php echo e(trans_choice('general.business',1)); ?></th>
                                            <th><?php echo e(trans_choice('general.unique',1)); ?>#</th>
                                            <th><?php echo e(trans_choice('general.mobile',1)); ?></th>
                                            <th><?php echo e(trans_choice('general.email',1)); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $loan->guarantors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(!empty($key->guarantor)): ?>
                                                <tr>
                                                    <td><?php echo e($key->guarantor->first_name); ?> <?php echo e($key->guarantor->last_name); ?></td>
                                                    <td><?php echo e($key->guarantor->business_name); ?></td>
                                                    <td><?php echo e($key->guarantor->unique_number); ?></td>
                                                    <td><?php echo e($key->guarantor->mobile); ?></td>
                                                    <td><?php echo e($key->guarantor->email); ?></td>

                                                </tr>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane" id="loan_files">
                            <ul class="" style="font-size:12px; padding-left:10px">

                                <?php $__currentLoopData = unserialize($loan->files); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a href="<?php echo asset('uploads/'.$value); ?>"
                                           target="_blank"><?php echo $value; ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>

                    </div>
                    <!-- /.tab-content -->
                </div>
            </div>
            <!-- nav-tabs-custom -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('client.layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>