
<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.saving',2)); ?> <?php echo e(trans_choice('general.detail',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-md-12">
            <!-- Custom Tabs -->
            <div class="panel panel-white">
                <div class="panel-body">
                    <ul class="nav nav-tabs">
                        <li class="active"><a href="#summary" data-toggle="tab"
                                              aria-expanded="false"> <?php echo e(trans_choice('general.summary',1)); ?></a>
                        </li>

                        <li class=""><a href="#transactions" data-toggle="tab"
                                        aria-expanded="false"><?php echo e(trans_choice('general.transaction',2)); ?> </a>
                        </li>
                        <li class="hidden"><a href="#on_hold" data-toggle="tab"
                                              aria-expanded="false"><?php echo e(trans_choice('general.on',1)); ?> <?php echo e(trans_choice('general.hold',2)); ?></a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="summary">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="input-group-btn">
                                        <button type="button" class="btn btn-sm btn-info m-10 dropdown-toggle"
                                                data-toggle="dropdown"
                                                aria-expanded="false"><?php echo e(trans_choice('general.saving',2)); ?> <?php echo e(trans_choice('general.statement',1)); ?>

                                            <span class="fa fa-caret-down"></span>
                                        </button>
                                        <ul class="dropdown-menu" role="menu">


                                            <li><a href="<?php echo e(url('client/saving/'.$saving->id.'/statement/print')); ?>"
                                                   target="_blank"><?php echo e(trans_choice('general.print',1)); ?> <?php echo e(trans_choice('general.statement',1)); ?></a>
                                            </li>

                                            <li><a href="<?php echo e(url('client/saving/'.$saving->id.'/statement/pdf')); ?>"
                                                   target="_blank"><?php echo e(trans_choice('general.download',1)); ?> <?php echo e(trans_choice('general.in',1)); ?> <?php echo e(trans_choice('general.pdf',1)); ?></a>
                                            </li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <table class="table" style="border: none">
                                        <tr>
                                            <td><?php echo e(trans_choice('general.account',1)); ?>#</td>
                                            <td><?php echo e($saving->id); ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo e(trans_choice('general.product',1)); ?></td>
                                            <td>
                                                <?php if(!empty($saving->savings_product)): ?>
                                                    <?php echo e($saving->savings_product->name); ?>

                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><?php echo e(trans_choice('general.minimum',1)); ?> <?php echo e(trans_choice('general.balance',1)); ?></td>
                                            <td>
                                                <?php if(!empty($saving->savings_product)): ?>
                                                    <?php echo e($saving->savings_product->minimum_balance); ?>

                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><?php echo e(trans_choice('general.interest_rate_per_annum',1)); ?></td>
                                            <td>
                                                <?php if(!empty($saving->savings_product)): ?>
                                                    <?php echo e($saving->savings_product->interest_rate); ?>

                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><?php echo e(trans_choice('general.interest_posting_frequency',1)); ?></td>
                                            <td>
                                                <?php if(!empty($saving->savings_product)): ?>
                                                    <?php if($saving->savings_product->interest_posting==1): ?>
                                                        <?php echo e(trans_choice('general.every_1_month',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($saving->savings_product->interest_posting==2): ?>
                                                        <?php echo e(trans_choice('general.every_2_month',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($saving->savings_product->interest_posting==3): ?>
                                                        <?php echo e(trans_choice('general.every_3_month',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($saving->savings_product->interest_posting==4): ?>
                                                        <?php echo e(trans_choice('general.every_4_month',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($saving->savings_product->interest_posting==5): ?>
                                                        <?php echo e(trans_choice('general.every_6_month',1)); ?>

                                                    <?php endif; ?>
                                                    <?php if($saving->savings_product->interest_posting==6): ?>
                                                        <?php echo e(trans_choice('general.every_12_month',1)); ?>


                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><?php echo e(trans_choice('general.allow_overdraft',1)); ?></td>
                                            <td>
                                                <?php if($saving->savings_product->allow_overdraw==0): ?>
                                                    <?php echo e(trans_choice('general.no',1)); ?>

                                                <?php endif; ?>
                                                <?php if($saving->savings_product->allow_overdraw==1): ?>
                                                    <?php echo e(trans_choice('general.yes',1)); ?>

                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="col-md-6">
                                    <table class="table" style="border: none">
                                        <?php $allocation = \App\Helpers\GeneralHelper::total_savings_transactions($saving->id) ?>
                                        <tr>
                                            <td><?php echo e(trans_choice('general.current',1)); ?> <?php echo e(trans_choice('general.balance',1)); ?></td>
                                            <td><?php echo e(number_format(\App\Helpers\GeneralHelper::savings_account_balance($saving->id),2)); ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.deposit',2)); ?></td>
                                            <td><?php echo e(number_format($allocation["deposits"],2)); ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.withdrawal',2)); ?></td>
                                            <td><?php echo e(number_format($allocation["withdrawals"],2)); ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.charge',2)); ?></td>
                                            <td><?php echo e(number_format($allocation["fees"],2)); ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.interest',1)); ?></td>
                                            <td><?php echo e(number_format($allocation["interest"],2)); ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo e(trans_choice('general.total',1)); ?> <?php echo e(trans_choice('general.on',2)); ?> <?php echo e(trans_choice('general.hold',2)); ?></td>
                                            <td><?php echo e(number_format($allocation["guarantee"],2)); ?></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane " id="transactions">
                            <div class="btn-group-horizontal">
                                <?php if(\App\Models\Setting::where('setting_key','enable_online_payment')->first()->setting_value==1): ?>
                                    <a type="button" class="btn btn-info m-10"
                                       href="<?php echo e(url('client/saving/'.$saving->id.'/pay')); ?>"><?php echo e(trans_choice('general.deposit',1)); ?>

                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="box box-info">
                                <div class="panel-body">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="table-responsive">
                                                <table id="repayments-data-table"
                                                       class="table  table-condensed table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th>
                                                            <?php echo e(trans_choice('general.id',1)); ?>

                                                        </th>
                                                        <th>
                                                            <?php echo e(trans_choice('general.date',1)); ?>

                                                        </th>
                                                        <th>
                                                            <?php echo e(trans_choice('general.submitted',1)); ?> <?php echo e(trans_choice('general.on',1)); ?>

                                                        </th>
                                                        <th>
                                                            <?php echo e(trans_choice('general.type',1)); ?>

                                                        </th>

                                                        <th>
                                                            <?php echo e(trans_choice('general.debit',1)); ?>

                                                        </th>
                                                        <th>
                                                            <?php echo e(trans_choice('general.credit',1)); ?>

                                                        </th>
                                                        <th>
                                                            <?php echo e(trans_choice('general.balance',1)); ?>

                                                        </th>
                                                        <th>
                                                            <?php echo e(trans_choice('general.detail',2)); ?>

                                                        </th>

                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php
                                                    $balance = 0;
                                                    ?>
                                                    <?php $__currentLoopData = \App\Models\SavingTransaction::where('savings_id',$saving->id)->whereIn('reversal_type',['user','none'])->orderBy('date', 'asc')->orderBy('time',
            'asc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                        $balance = $balance + ($key->credit - $key->debit);
                                                        ?>
                                                        <tr>
                                                            <td><?php echo e($key->id); ?></td>
                                                            <td><?php echo e($key->date); ?> <?php echo e($key->time); ?></td>
                                                            <td><?php echo e($key->created_at); ?></td>
                                                            <td>
                                                                <?php if($key->type=='deposit'): ?>
                                                                    <?php echo e(trans_choice('general.deposit',1)); ?>

                                                                <?php endif; ?>
                                                                <?php if($key->type=='withdrawal'): ?>
                                                                    <?php echo e(trans_choice('general.withdrawal',1)); ?>

                                                                <?php endif; ?>
                                                                <?php if($key->type=='bank_fees'): ?>
                                                                    <?php echo e(trans_choice('general.charge',1)); ?>

                                                                <?php endif; ?>
                                                                <?php if($key->type=='interest'): ?>
                                                                    <?php echo e(trans_choice('general.interest',1)); ?>

                                                                <?php endif; ?>
                                                                <?php if($key->type=='dividend'): ?>
                                                                    <?php echo e(trans_choice('general.dividend',1)); ?>

                                                                <?php endif; ?>
                                                                <?php if($key->type=='transfer'): ?>
                                                                    <?php echo e(trans_choice('general.transfer',1)); ?>

                                                                <?php endif; ?>
                                                                <?php if($key->type=='transfer_fund'): ?>
                                                                    <?php echo e(trans_choice('general.transfer',1)); ?>

                                                                <?php endif; ?>
                                                                <?php if($key->type=='transfer_loan'): ?>
                                                                    <?php echo e(trans_choice('general.transfer',1)); ?>

                                                                <?php endif; ?>
                                                                <?php if($key->type=='guarantee'): ?>
                                                                    <?php echo e(trans_choice('general.on',1)); ?> <?php echo e(trans_choice('general.hold',1)); ?>

                                                                <?php endif; ?>
                                                                <?php if($key->reversed==1): ?>
                                                                    <?php if($key->reversal_type=="user"): ?>
                                                                        <span class="text-danger"><b>(<?php echo e(trans_choice('general.user',1)); ?> <?php echo e(trans_choice('general.reversed',1)); ?>

                                                                                )</b></span>
                                                                    <?php endif; ?>
                                                                    <?php if($key->reversal_type=="system"): ?>
                                                                        <span class="text-danger"><b>(<?php echo e(trans_choice('general.system',1)); ?> <?php echo e(trans_choice('general.reversed',1)); ?>

                                                                                )</b></span>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>
                                                            </td>
                                                            <td><?php echo e(number_format($key->debit,2)); ?></td>
                                                            <td><?php echo e(number_format($key->credit,2)); ?></td>
                                                            <td><?php echo e(number_format($balance,2)); ?></td>
                                                            <td><?php echo e($key->receipt); ?></td>

                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>
    <script>

        $('#repayments-data-table').DataTable({
            dom: '<"datatable-header"fl><"datatable-scroll"t><"datatable-footer"ip>',
            autoWidth: false,
            columnDefs: [{
                orderable: false,
                width: '100px',
                targets: [8]
            }],
            "order": [[1, "asc"]],
            language: {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>:",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            },
            drawCallback: function () {
                $('.delete').on('click', function (e) {
                    e.preventDefault();
                    var href = $(this).attr('href');
                    swal({
                        title: 'Are you sure?',
                        text: '',
                        type: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Ok',
                        cancelButtonText: 'Cancel'
                    }).then(function () {
                        window.location = href;
                    })
                });
            }
        });
    </script>
    <script>
        $(document).ready(function () {
            $('.deleteLoan').on('click', function (e) {
                e.preventDefault();
                var href = $(this).attr('href');
                swal({
                    title: '<?php echo e(trans_choice('general.are_you_sure',1)); ?>',
                    text: '<?php echo e(trans_choice('general.delete_loan_msg',1)); ?>',
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: '<?php echo e(trans_choice('general.ok',1)); ?>',
                    cancelButtonText: '<?php echo e(trans_choice('general.cancel',1)); ?>'
                }).then(function () {
                    window.location = href;
                })
            });
            $('.deletePayment').on('click', function (e) {
                e.preventDefault();
                var href = $(this).attr('href');
                swal({
                    title: '<?php echo e(trans_choice('general.are_you_sure',1)); ?>',
                    text: '<?php echo e(trans_choice('general.delete_payment_msg',1)); ?>',
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: '<?php echo e(trans_choice('general.ok',1)); ?>',
                    cancelButtonText: '<?php echo e(trans_choice('general.cancel',1)); ?>'
                }).then(function () {
                    window.location = href;
                })
            });
            $('.deleteComment').on('click', function (e) {
                e.preventDefault();
                var href = $(this).attr('href');
                swal({
                    title: '<?php echo e(trans_choice('general.are_you_sure',1)); ?>',
                    text: '',
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: '<?php echo e(trans_choice('general.ok',1)); ?>',
                    cancelButtonText: '<?php echo e(trans_choice('general.cancel',1)); ?>'
                }).then(function () {
                    window.location = href;
                })
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('client.layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>