
<?php $__env->startSection('title'); ?><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.application',2)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="panel panel-white">
        <div class="panel-heading">
            <h6 class="panel-title"><?php echo e(trans_choice('general.loan',1)); ?> <?php echo e(trans_choice('general.application',2)); ?></h6>

            <div class="heading-elements">

            </div>
        </div>
        <div class="panel-body table-responsive">
            <table id="data-table" class="table table-striped table-condensed table-hover">
                <thead>
                <tr>
                    <th>#</th>
                    <th><?php echo e(trans_choice('general.borrower',1)); ?></th>
                    <th><?php echo e(trans_choice('general.product',1)); ?></th>
                    <th><?php echo e(trans_choice('general.amount',1)); ?></th>
                    <th><?php echo e(trans_choice('general.status',1)); ?></th>
                    <th><?php echo e(trans_choice('general.note',2)); ?></th>
                    <th><?php echo e(trans_choice('general.date',1)); ?></th>
                    <th><?php echo e(trans_choice('general.action',1)); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key->id); ?></td>
                        <td>
                            <?php if(!empty($key->borrower)): ?>
                                <a href="<?php echo e(url('borrower/'.$key->borrower_id.'/show')); ?>"><?php echo e($key->borrower->first_name); ?> <?php echo e($key->borrower->last_name); ?></a>
                            <?php else: ?>
                                <span class="label label-danger"><?php echo e(trans_choice('general.broken',1)); ?> <i
                                            class="fa fa-exclamation-triangle"></i> </span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if(!empty($key->loan_product)): ?>
                                <a href="<?php echo e(url('loan/loan_product/'.$key->loan_product_id.'/edit')); ?>"><?php echo e($key->loan_product->name); ?></a>
                            <?php else: ?>
                                <span class="label label-danger"><?php echo e(trans_choice('general.broken',1)); ?> <i
                                            class="fa fa-exclamation-triangle"></i> </span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e(round($key->amount,2)); ?></td>
                        <td>
                            <?php if($key->status=='declined'): ?>
                                <span class="label label-danger"><?php echo e(trans_choice('general.declined',1)); ?></span>
                            <?php endif; ?>
                            <?php if($key->status=='approved'): ?>
                                <span class="label label-success"><?php echo e(trans_choice('general.approved',1)); ?></span>
                            <?php endif; ?>
                            <?php if($key->status=='pending'): ?>
                                <span class="label label-warning"><?php echo e(trans_choice('general.pending',1)); ?></span>
                            <?php endif; ?>
                        </td>

                        <td><?php echo $key->notes; ?></td>
                        <td><?php echo $key->created_at; ?></td>
                        <td>
                            <ul class="icons-list">
                                <li class="dropdown">
                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                        <i class="icon-menu9"></i>
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-right" role="menu">
                                        <?php if($key->status=='pending' || $key->status=="declined"): ?>
                                            <?php if(Sentinel::hasAccess('loans.create')): ?>
                                                <li><a href="<?php echo e(url('loan/loan_application/'.$key->id.'/approve')); ?>"><i
                                                                class="fa fa-check"></i> <?php echo e(trans('general.approve')); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <?php if( $key->status=="pending"): ?>
                                            <?php if(Sentinel::hasAccess('loans.update')): ?>
                                                <li><a href="<?php echo e(url('loan/loan_application/'.$key->id.'/decline')); ?>"><i
                                                                class="fa fa-minus-circle"></i> <?php echo e(trans('general.decline')); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <?php if(Sentinel::hasAccess('loans.delete')): ?>
                                            <li><a href="<?php echo e(url('loan/loan_application/'.$key->id.'/delete')); ?>"
                                                   class="delete"><i
                                                            class="fa fa-trash"></i> <?php echo e(trans('general.delete')); ?> </a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </li>
                            </ul>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <!-- /.panel-body -->
    </div>
    <!-- /.box -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>

    <script>
        $('#data-table').DataTable({
            "order": [[6, "desc"]],
            "columnDefs": [
                {"orderable": false, "targets": [7]}
            ],
            "language": {
                "lengthMenu": "<?php echo e(trans('general.lengthMenu')); ?>",
                "zeroRecords": "<?php echo e(trans('general.zeroRecords')); ?>",
                "info": "<?php echo e(trans('general.info')); ?>",
                "infoEmpty": "<?php echo e(trans('general.infoEmpty')); ?>",
                "search": "<?php echo e(trans('general.search')); ?>",
                "infoFiltered": "<?php echo e(trans('general.infoFiltered')); ?>",
                "paginate": {
                    "first": "<?php echo e(trans('general.first')); ?>",
                    "last": "<?php echo e(trans('general.last')); ?>",
                    "next": "<?php echo e(trans('general.next')); ?>",
                    "previous": "<?php echo e(trans('general.previous')); ?>"
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>