<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo e($saving->borrower->title); ?> <?php echo e($saving->borrower->first_name); ?> <?php echo e($saving->borrower->last_name); ?></title>
    <link rel="stylesheet" href="<?php echo e(asset('assets/bootstrap/css/bootstrap.min.css')); ?>">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/dist/css/AdminLTE.min.css')); ?>">
    <style type="text/css" media="print">
        @page  {
            size: auto;   /* auto is the initial value */
            margin: 0mm;  /* this affects the margin in the printer settings */
        }

        html {
            background-color: #FFFFFF;
            margin: 0px; /* this affects the margin on the html before sending to printer */
        }

        body {
            margin: 10mm 10mm 10mm 10mm; /* margin you want for the content */
        }
    </style>
</head>
<body>
<div class="wrapper">
    <!-- Main content -->
    <section class="invoice">
        <!-- title row -->
        <div class="row">
            <div class="col-xs-12">
            </div>
            <div class="col-xs-12">
                <div class="text-center">

                    <h2 class="page-header">
                        <?php echo e(\App\Models\Setting::where('setting_key','company_name')->first()->setting_value); ?>

                        <small class="pull-right"></small>
                    </h2>
                    <h4><?php echo e(trans_choice('general.saving',2)); ?> <?php echo e(trans_choice('general.account',1)); ?> <?php echo e(trans_choice('general.statement',1)); ?></h4>
                    <strong><?php echo e(trans_choice('general.date',1)); ?>: </strong><?php echo e(date("Y-m-d")); ?><br><br>
                </div>
                <br>
            </div>
            <!-- /.col -->
        </div>
        <!-- info row -->

        <div class="row invoice-info">
            <div class="col-sm-6">
                <address>
                    <b><?php echo e($saving->borrower->title); ?> <?php echo e($saving->borrower->first_name); ?> <?php echo e($saving->borrower->last_name); ?></b><br>
                </address>
            </div>
        </div>
        <!-- /.row -->
        <!-- Table row -->
        <div class="row">
            <div class="col-xs-12 table-responsive">
                <table class="table table-striped">
                    <thead>
                    <tr>
                        <th><?php echo e(trans_choice('general.account',1)); ?>#</th>
                        <th><?php echo e(trans_choice('general.product',1)); ?></th>
                        <th><?php echo e(trans_choice('general.minimum',1)); ?> <?php echo e(trans_choice('general.balance',1)); ?></th>
                        <th><?php echo e(trans_choice('general.interest_rate_per_annum',1)); ?></th>
                        <th><?php echo e(trans_choice('general.interest_posting_frequency',1)); ?></th>
                        <th style="text-align:right"><?php echo e(trans_choice('general.current',1)); ?> <?php echo e(trans_choice('general.balance',1)); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td><?php echo e($saving->id); ?></td>
                        <td>
                            <?php if(!empty($saving->savings_product)): ?>
                                <?php echo e($saving->savings_product->name); ?>

                            <?php endif; ?>
                        </td>
                        <td><?php echo e($saving->savings_product->minimum_balance); ?></td>
                        <td><?php echo e($saving->savings_product->interest_rate); ?></td>
                        <td>
                            <?php if($saving->savings_product->interest_posting==1): ?>
                                <?php echo e(trans_choice('general.every_1_month',1)); ?>

                            <?php endif; ?>
                            <?php if($saving->savings_product->interest_posting==2): ?>
                                <?php echo e(trans_choice('general.every_2_month',1)); ?>

                            <?php endif; ?>
                            <?php if($saving->savings_product->interest_posting==3): ?>
                                <?php echo e(trans_choice('general.every_3_month',1)); ?>

                            <?php endif; ?>
                            <?php if($saving->savings_product->interest_posting==4): ?>
                                <?php echo e(trans_choice('general.every_4_month',1)); ?>

                            <?php endif; ?>
                            <?php if($saving->savings_product->interest_posting==5): ?>
                                <?php echo e(trans_choice('general.every_6_month',1)); ?>

                            <?php endif; ?>
                            <?php if($saving->savings_product->interest_posting==6): ?>
                                <?php echo e(trans_choice('general.every_12_month',1)); ?>


                            <?php endif; ?>
                        </td>
                        <td style="text-align:right">
                            <b><?php echo e(round(\App\Helpers\GeneralHelper::savings_account_balance($saving->id),2)); ?></b></td>
                    </tr>
                    </tbody>
                </table>
                <table class="table table-striped">
                    <thead>
                    <tr>
                        <th>
                            <?php echo e(trans_choice('general.id',1)); ?>

                        </th>
                        <th>
                            <?php echo e(trans_choice('general.date',1)); ?>

                        </th>
                        <th>
                            <?php echo e(trans_choice('general.submitted',1)); ?> <?php echo e(trans_choice('general.on',1)); ?>

                        </th>
                        <th>
                            <?php echo e(trans_choice('general.type',1)); ?>

                        </th>

                        <th>
                            <?php echo e(trans_choice('general.debit',1)); ?>

                        </th>
                        <th>
                            <?php echo e(trans_choice('general.credit',1)); ?>

                        </th>
                        <th>
                            <?php echo e(trans_choice('general.balance',1)); ?>

                        </th>
                        <th>
                            <?php echo e(trans_choice('general.detail',2)); ?>

                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $balance = 0;
                    ?>
                    <?php $__currentLoopData = \App\Models\SavingTransaction::where('savings_id',$saving->id)->whereIn('reversal_type',['user','none'])->orderBy('created_at', 'DESC')->orderBy('time',
'asc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $balance = $balance + ($key->credit - $key->debit);
                        ?>
                        <tr>
                            <td><?php echo e($key->id); ?></td>
                            <td><?php echo e($key->date); ?> <?php echo e($key->time); ?></td>
                            <td><?php echo e($key->created_at); ?></td>
                            <td>
                                <?php if($key->type=='deposit'): ?>
                                    <?php echo e(trans_choice('general.deposit',1)); ?>

                                <?php endif; ?>
                                <?php if($key->type=='withdrawal'): ?>
                                    <?php echo e(trans_choice('general.withdrawal',1)); ?>

                                <?php endif; ?>
                                <?php if($key->type=='bank_fees'): ?>
                                    <?php echo e(trans_choice('general.charge',1)); ?>

                                <?php endif; ?>
                                <?php if($key->type=='interest'): ?>
                                    <?php echo e(trans_choice('general.interest',1)); ?>

                                <?php endif; ?>
                                <?php if($key->type=='dividend'): ?>
                                    <?php echo e(trans_choice('general.dividend',1)); ?>

                                <?php endif; ?>
                                <?php if($key->type=='transfer'): ?>
                                    <?php echo e(trans_choice('general.transfer',1)); ?>

                                <?php endif; ?>
                                <?php if($key->type=='transfer_fund'): ?>
                                    <?php echo e(trans_choice('general.transfer',1)); ?>

                                <?php endif; ?>
                                <?php if($key->type=='transfer_loan'): ?>
                                    <?php echo e(trans_choice('general.transfer',1)); ?>

                                <?php endif; ?>
                                <?php if($key->type=='guarantee'): ?>
                                    <?php echo e(trans_choice('general.on',1)); ?> <?php echo e(trans_choice('general.hold',1)); ?>

                                <?php endif; ?>
                                <?php if($key->reversed==1): ?>
                                    <?php if($key->reversal_type=="user"): ?>
                                        <span class="text-danger"><b>(<?php echo e(trans_choice('general.user',1)); ?> <?php echo e(trans_choice('general.reversed',1)); ?>

                                                )</b></span>
                                    <?php endif; ?>
                                    <?php if($key->reversal_type=="system"): ?>
                                        <span class="text-danger"><b>(<?php echo e(trans_choice('general.system',1)); ?> <?php echo e(trans_choice('general.reversed',1)); ?>

                                                )</b></span>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e(number_format($key->debit,2)); ?></td>
                            <td><?php echo e(number_format($key->credit,2)); ?></td>
                            <td><?php echo e(number_format($balance,2)); ?></td>
                            <td><?php echo e($key->receipt); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>


    </section>
</div>
<script>
    window.onload = function () {
        window.print();
    }
</script>
</body>
</html>