
<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('general.ledger',1)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="panel panel-white">
        <div class="panel-heading">
            <h6 class="panel-title">
                <?php echo e(trans_choice('general.ledger',1)); ?>

                <?php if(!empty($start_date)): ?>
                    for period: <b><?php echo e($start_date); ?> to <?php echo e($end_date); ?></b>
                <?php endif; ?>
            </h6>

            <div class="heading-elements">
                <button class="btn btn-sm btn-info hidden-print" onclick="window.print()">Print</button>
            </div>
        </div>
        <div class="panel-body hidden-print">
            <h4 class=""><?php echo e(trans_choice('general.date',1)); ?> <?php echo e(trans_choice('general.range',1)); ?></h4>
            <?php echo Form::open(array('url' => Request::url(), 'method' => 'post','class'=>'form-horizontal', 'name' => 'form')); ?>

            <div class="row">
                <div class="col-xs-5">
                    <?php echo Form::text('start_date',$start_date, array('class' => 'form-control date-picker', 'placeholder'=>"From Date",'required'=>'required')); ?>

                </div>
                <div class="col-xs-1  text-center" style="padding-top: 5px;">
                    to
                </div>
                <div class="col-xs-5">
                    <?php echo Form::text('end_date',$end_date, array('class' => 'form-control date-picker', 'placeholder'=>"To Date",'required'=>'required')); ?>

                </div>
            </div>
            <div class="panel-body">
                <div class="row">
                    <div class="col-xs-2">
                        <span class="input-group-btn">
                          <button type="submit" class="btn btn-info"><?php echo e(trans_choice('general.search',1)); ?>!
                          </button>
                        </span>
                        <span class="input-group-btn">
                          <a href="<?php echo e(Request::url()); ?>"
                             class="btn bg-purple  btn-flat pull-right"><?php echo e(trans_choice('general.reset',1)); ?>!</a>
                        </span>
                    </div>
                </div>
            </div>
            <?php echo Form::close(); ?>


        </div>
        <!-- /.panel-body -->

    </div>
    <!-- /.box -->
    <?php if(!empty($start_date)): ?>
        <div class="panel panel-white">
            <div class="panel-body table-responsive no-padding">


                <table class="table table-bordered table-condensed table-hover">
                    <thead>
                    <tr style="background-color: #D1F9FF">
                        <th><?php echo e(trans_choice('general.gl_code',1)); ?></th>
                        <th><?php echo e(trans_choice('general.account',1)); ?></th>
                        <th><?php echo e(trans_choice('general.debit',1)); ?></th>
                        <th><?php echo e(trans_choice('general.credit',1)); ?></th>
                        <th><?php echo e(trans_choice('general.balance',1)); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $credit_total = 0;
                    $debit_total = 0;
                    ?>
                    <?php $__currentLoopData = \App\Models\ChartOfAccount::orderBy('gl_code','asc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $cr = 0;
                        $dr = 0;
                        $cr = \App\Models\JournalEntry::where('account_id', $key->id)->whereBetween('date',
                            [$start_date, $end_date])->sum('credit');
                        $dr = \App\Models\JournalEntry::where('account_id', $key->id)->whereBetween('date',
                            [$start_date, $end_date])->sum('debit');
                        $credit_total = $credit_total + $cr;
                        $debit_total = $debit_total + $dr;
                        ?>
                        <tr>
                            <td><?php echo e($key->gl_code); ?></td>
                            <td>
                                <?php echo e($key->name); ?>

                            </td>
                            <td><?php echo e(number_format($dr,2)); ?></td>
                            <td><?php echo e(number_format($cr,2)); ?></td>
                            <td>
                                <?php if($dr>$cr): ?>
                                    <?php echo e(number_format($dr-$cr,2)); ?> Dr
                                <?php elseif($cr>$dr): ?>
                                    <?php echo e(number_format($cr-$dr,2)); ?> Cr
                                <?php else: ?>
                                    0
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <td colspan="2"><b><?php echo e(trans_choice('general.total',1)); ?></b></td>
                        <td><?php echo e(number_format($debit_total,2)); ?></td>
                        <td><?php echo e(number_format($credit_total,2)); ?></td>
                        <td></td>
                    </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    <?php else: ?>
        <div class="panel panel-white">
            <div class="panel-body table-responsive no-padding">


                <table class="table table-bordered table-condensed table-hover">
                    <thead>
                    <tr style="background-color: #D1F9FF">
                        <th><?php echo e(trans_choice('general.gl_code',1)); ?></th>
                        <th><?php echo e(trans_choice('general.account',1)); ?></th>
                        <th><?php echo e(trans_choice('general.debit',1)); ?></th>
                        <th><?php echo e(trans_choice('general.credit',1)); ?></th>
                        <th><?php echo e(trans_choice('general.balance',1)); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $credit_total = 0;
                    $debit_total = 0;
                    ?>
                    <?php $__currentLoopData = \App\Models\ChartOfAccount::orderBy('gl_code','asc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $cr = 0;
                        $dr = 0;
                        $cr = \App\Models\JournalEntry::where('account_id', $key->id)->sum('credit');
                        $dr = \App\Models\JournalEntry::where('account_id', $key->id)->sum('debit');
                        $credit_total = $credit_total + $cr;
                        $debit_total = $debit_total + $dr;
                        ?>
                        <tr>
                            <td><?php echo e($key->gl_code); ?></td>
                            <td>
                                <?php echo e($key->name); ?>

                            </td>
                            <td><?php echo e(number_format($dr,2)); ?></td>
                            <td><?php echo e(number_format($cr,2)); ?></td>
                            <td>
                                <?php if($dr>$cr): ?>
                                    <?php echo e(number_format($dr-$cr,2)); ?> Dr
                                <?php elseif($cr>$dr): ?>
                                    <?php echo e(number_format($cr-$dr,2)); ?> Cr
                                <?php else: ?>
                                    0
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <td colspan="2"><b><?php echo e(trans_choice('general.total',1)); ?></b></td>
                        <td><?php echo e(number_format($debit_total,2)); ?></td>
                        <td><?php echo e(number_format($credit_total,2)); ?></td>
                        <td></td>
                    </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer-scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>